﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.Utils;
using BMS.ServicesWrapper.Proxy.EIS;

namespace BMS.ServicesWrapper.EIS
{
    /// <summary>
    /// EIS factory class responsible for EIS wrapper creation and proxy accessing.
    /// </summary>
    public class EISFactory
    {
        /// <summary>
        /// The underlying IEISWrapper instance as readonly.
        /// </summary>
        private static readonly IEISWrapper _instance = new EISWrapper(false);

        /// <summary>
        /// The underlying IEISWrapper instance for Windows as readonly.
        /// </summary>
        private static readonly IEISWrapper _instanceWindows = new EISWrapper(true);

        /// <summary>
        /// The EISWrapper instance used by clients.
        /// </summary>
        public static IEISWrapper Instance
        {
            get { return EISFactory._instance; }
        }
        /// <summary>
        /// The EISWrapper Windows instance used by clients.
        /// </summary>
        public static IEISWrapper InstanceWindows
        {
            get { return EISFactory._instanceWindows; }
        }
        /// <summary>
        /// The client instance used by calls from WCF/WF that use the DurableIssuedTokenClientCredentials
        /// if there is a current SessionID or the windows instance otherwise.
        /// </summary>
        public static IEISWrapper InstanceFromWCF
        {
            get
            {
                if (!String.IsNullOrEmpty(ProxyManager.GetCurrentSessionID()))
                    return Instance;
                else
                    return InstanceWindows;
            }
        }
        /// <summary>
        /// Private instance used to access the internal methods.
        /// </summary>
        private static EISWrapper EISWrapperInstance
        {
            get { return _instance as EISWrapper; }
        }

        /// <summary>
        /// Private Windows instance used to access the internal methods.
        /// </summary>
        private static EISWrapper EISWrapperInstanceWindows
        {
            get { return _instanceWindows as EISWrapper; }
        }

        /// <summary>
        /// Access to the EIS QueryFunctions WCF proxy.
        /// </summary>
        internal static QueryFunctionsClient QueryFunctionsClient
        {
            get { return ProxyManager.GetProxy<QueryFunctionsClient>("EIS.QueryFunctions"); }
        }

        /// <summary>
        /// Access to the EIS QueryFunctions WCF proxy using windows authentication.
        /// </summary>
        internal static QueryFunctionsClient QueryFunctionsClientWindows
        {
            get { return ProxyManager.GetProxy<QueryFunctionsClient>("EIS.QueryFunctions.Windows"); }
        }

        /// <summary>
        /// Access to the EIS EntityManagement WCF proxy.
        /// </summary>
        internal static EntityManagementClient EntityManagementClient
        {
            get { return ProxyManager.GetProxy<EntityManagementClient>("EIS.EntityManagement"); }
        }
        /// <summary>
        /// Access to the EIS EntityManagement WCF proxy using Windows authentication.
        /// </summary>
        internal static EntityManagementClient EntityManagementClientWindows
        {
            get { return ProxyManager.GetProxy<EntityManagementClient>("EIS.EntityManagement.Windows"); }
        }
    }

}
